package com.atlassian.aws.utils;


import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;

import java.time.Duration;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;

/**
 * @deprecated replace with BambooSuppliers
 */
@Deprecated
public class AwsSuppliers
{
    private static class LazilyExpiringMemoizingSupplier<T> implements Supplier<T>
    {
        private final Supplier<T> supplier;
        private final LongUnaryOperator ttlCalculator;

        private transient volatile T value;
        private transient volatile long expirationTime;

        LazilyExpiringMemoizingSupplier(final Supplier<T> supplier, final LongUnaryOperator ttlCalculator)
        {
            this.supplier = Objects.requireNonNull(supplier);
            this.ttlCalculator = ttlCalculator;
        }

        @Override
        public T get()
        {
            final long expirationTimeWhenMethodWasCalled = expirationTime;

            if (expirationTimeWhenMethodWasCalled == 0 || System.nanoTime() - expirationTimeWhenMethodWasCalled >= 0)
            {
                synchronized (this)
                {
                    if (expirationTimeWhenMethodWasCalled != expirationTime)
                    {
                        return value;
                    }
                    final long calculationStarted = System.nanoTime();
                    final T calculated = supplier.get();
                    value = calculated;

                    final long now = System.nanoTime();
                    final long newExpirationTime = now + ttlCalculator.applyAsLong(now - calculationStarted);

                    //fun fact, now can be negative
                    expirationTime = newExpirationTime == 0 ? 1 : newExpirationTime;
                    return calculated;
                }
            }
            return value;
        }
    }

    /**
     * Memoizes the provided supplier. The value is guaranteed to be no more than ttl old.
     * TTL countdown starts when the provided supplier's get method returns.
     */
    @NotNull
    public static <T> Supplier<T> memoizeWithFixedTtl(@NotNull  final Supplier<T> supplier, @NotNull final Duration ttl)
    {
        final long ttlNanos = ttl.toNanos();
        Preconditions.checkArgument(ttlNanos > 0);

        return new LazilyExpiringMemoizingSupplier<>(supplier, ignored -> ttlNanos);
    }

    /**
     * Memoizes the provided supplier. The value is guaranteed to be no more than &lt;minTtl;maxTtl&gt; old.
     * The actual TTL value used is equal to the time taken by the supplier.get(), capped by the ttl range.
     * TTL countdown starts when the provided supplier's get method returns.
     */
    @NotNull
    public static <T> Supplier<T> memoizeWithAdaptiveTtl(final Supplier<T> supplier, final Duration minTtl, final Duration maxTtl)
    {
        final long minTtlNanos = minTtl.toNanos();
        Preconditions.checkArgument(minTtlNanos > 0);

        final long maxTtlNanos = maxTtl.toNanos();
        Preconditions.checkArgument(maxTtlNanos > 0);

        Preconditions.checkArgument(minTtlNanos <= maxTtlNanos);

        return new LazilyExpiringMemoizingSupplier<>(supplier, elapsed -> {
            if (elapsed>=maxTtlNanos)
            {
                return maxTtlNanos;
            }
            else if (elapsed<=minTtlNanos)
            {
                return minTtlNanos;
            }
            else
            {
                return elapsed;
            }
        });
    }
}
