package com.atlassian.aws.ec2.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Encapsulates a spot request string id.
 */
public class SpotRequestId extends ResourceId<SpotRequestId>
{
    public SpotRequestId(@NotNull final String id)
    {
        super(id);
        Preconditions.checkArgument(isValid(id));
    }

    public static boolean isValid(@Nullable final CharSequence id)
    {
        return StringUtils.startsWith(id, "spot-");
    }

    public static SpotRequestId from(@NotNull  final String spotRequestId)
    {
        return new SpotRequestId(spotRequestId);
    }
}
