package com.atlassian.aws.ec2.model;

import com.amazonaws.services.ec2.model.Subnet;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Encapsulates Availability Zone string id.
 */
public final class AvailabilityZoneId extends ResourceId<AvailabilityZoneId>
{
    private AvailabilityZoneId(final String availabilityZoneId)
    {
        super(availabilityZoneId);
    }

    public static AvailabilityZoneId from(final String availabilityZone)
    {
        return new AvailabilityZoneId(availabilityZone);
    }

    public static Iterable<AvailabilityZoneId> from(final Iterable<String> availabilityZones)
    {
        return ResourceId.from(availabilityZones, AvailabilityZoneId::from);
    }

    public static Iterable<AvailabilityZoneId> fromSubnets(final Iterable<Subnet> subnets)
    {
        final List<String> subnetIds = StreamSupport.stream(subnets.spliterator(), false)
                .map(SubnetId.GET_AZ::apply)
                .collect(Collectors.toList());
        return from(new LinkedHashSet<>(subnetIds));
    }
}
