package com.atlassian.aws.ec2.caches;


import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.AwsOmeCache;
import org.apache.log4j.Logger;

import java.time.Duration;
import java.util.List;

public class SubnetCache extends AwsOmeCache<Subnet>
{
    private static final Logger log = Logger.getLogger(SubnetCache.class);

    private final AmazonEC2Async ec2Client;

    public SubnetCache(final AmazonEC2Async ec2Client, final Duration maximumDataAge)
    {
        super(log, maximumDataAge);
        this.ec2Client = ec2Client;
    }

    public SubnetCache(final AmazonEC2Async ec2Client)
    {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Subnet> refreshAllData()
    {
        final DescribeSubnetsResult describeVpcsResult = ec2Client.describeSubnets();
        return describeVpcsResult.getSubnets();
    }

    @Override
    protected String toResourceId(final Subnet subnet)
    {
        return subnet.getSubnetId();
    }

    @Override
    protected void onResourceLookupFailure(final String resourceId)
    {
        throw new Ec2CacheMissException(resourceId, AmazonServiceErrorCode.INVALID_SUBNET_ID_NOT_FOUND);
    }
}
