package com.atlassian.aws.ec2.caches;

import com.amazonaws.AmazonServiceException;
import com.atlassian.aws.AmazonServiceErrorCode;
import org.apache.log4j.Logger;

public class Ec2CacheMissException extends AmazonServiceException
{
    private static final Logger log = Logger.getLogger(Ec2CacheMissException.class);
    private static final String EC2_SERVICE_NAME = "AmazonEC2";
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors
    // ----------------------------------------------------------------------------------------------- Interface Methods
    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators

    public Ec2CacheMissException(final String resourceId, final AmazonServiceErrorCode errorCode)
    {
        super("The resource with ID '" + resourceId + "' does not exist");

        setErrorCode(errorCode.toString());
        setRequestId("none");
        setStatusCode(400);
        setErrorType(AmazonServiceException.ErrorType.Unknown);
        setServiceName(EC2_SERVICE_NAME);
    }
}
