package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import org.apache.log4j.Logger;

public class Ec2Support
{
    private static final Logger log = Logger.getLogger(Ec2Support.class);

    private Ec2Support()
    {
    }

    public static String getEndpoint(final Regions region)
    {
        return getEndpoint(RegionSupport.toRegion(region));
    }

    private static String getEndpoint(final Region region)
    {
        return region.getServiceEndpoint(AmazonEC2.ENDPOINT_PREFIX);
    }
}
