package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.model.SubnetId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDelegatingInstanceReservationDescription implements InstanceReservationDescription {
    private final InstanceReservationDescription delegate;

    public AbstractDelegatingInstanceReservationDescription(InstanceReservationDescription delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getInstanceId() {
        return delegate.getInstanceId();
    }

    @Override
    public String getAvailabilityZone() {
        return delegate.getAvailabilityZone();
    }

    @Override
    @Nullable
    public SubnetId getSubnet() {
        return delegate.getSubnet();
    }

    @Override
    @NotNull
    public String getAddress() {
        return delegate.getAddress();
    }

    @Override
    @Nullable
    public InstanceType getInstanceType() {
        return delegate.getInstanceType();
    }

    @Override
    @NotNull
    public String getHostname() {
        return delegate.getHostname();
    }

    @Override
    public AwsSupportConstants.InstanceStateName getState() {
        return delegate.getState();
    }

    @Override
    public String getStateDescription() {
        return delegate.getStateDescription();
    }
}
