package com.atlassian.aws.ec2;

import org.apache.log4j.Logger;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Schedules polling updates to EC2 in a controlled manner
 */
public class UpdateSchedulerImpl implements UpdateScheduler, Runnable
{
    private static final Logger log = Logger.getLogger(UpdateSchedulerImpl.class);
    private static final int DELAY = 30;
    private static final int INITIAL_DELAY = 0;
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties

    private final Lock updateLock = new ReentrantLock();
    private final CopyOnWriteArrayList<Runnable> updateTasks = new CopyOnWriteArrayList<Runnable>();

    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors

    public UpdateSchedulerImpl(ScheduledExecutorService scheduledExecutorService)
    {
        scheduledExecutorService.scheduleWithFixedDelay(this, INITIAL_DELAY, DELAY, TimeUnit.SECONDS);
    }

    // ----------------------------------------------------------------------------------------------- Interface Methods

    public void run()
    {
        if (updateLock.tryLock())
        {
            try
            {
                for (Runnable runnable : updateTasks)
                {
                    try
                    {
                        runnable.run();
                    }
                    catch (Throwable e)
                    {
                        log.error("Could not execute '" + runnable.getClass() + "'", e);
                    }
                }
            }
            finally
            {
                updateLock.unlock();
            }
        }
    }

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods

    public void addUpdateTask(Runnable runnable)
    {
        updateTasks.add(runnable);
    }

    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
