package com.atlassian.aws.ec2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import java.util.Map;
import java.util.Set;

class InstanceFamilyData {
    static final Map<String, String> familyNames = ImmutableMap.<String, String>builder()
            .put("A1", "ARM Accelerated")
            .put("C1", "Old Compute Optimized")
            .put("C3", "Compute Optimized")
            .put("C4", "Compute Optimized")
            .put("C5", "Compute Optimized")
            .put("C5D", "Compute Optimized with Local Storage")
            .put("C5N", "Compute Optimized with High Performance Networking")
            .put("CC2", "Old Cluster Compute Optimized")
            .put("CG1", "Old Cluster GPU")
            .put("CR1", "Old Memory Optimized Cluster")
            .put("D2", "Storage Optimized HDD")
            .put("F1", "FPGA Accelerated")
            .put("G2", "Accelerated Computing GPU")
            .put("G3", "Graphics Intensive")
            .put("G3S", "Graphics Intensive")
            .put("H1", "Storage Optimized")
            .put("HI1", "Old Storage Optimized")
            .put("HS1", "Old Storage Optimized")
            .put("I2", "Storage Optimized")
            .put("I3", "Storage Optimized SSD")
            .put("M1", "Old General Purpose")
            .put("M2", "Old Memory Optimized")
            .put("M3", "General Purpose")
            .put("M4", "General Purpose")
            .put("M5", "Latest General Purpose")
            .put("M5D", "Latest General Purpose with Local Storage")
            .put("M5A", "Latest General Purpose with AMD Processor")
            .put("M5AD", "Latest General Purpose with Local Storage and AMD Processor")
            .put("P2", "Accelerated Computing GPU")
            .put("P3", "Latest Accelerated Computing GPU")
            .put("P3DN", "Latest Accelerated Computing GPU")
            .put("R3", "Memory Optimized")
            .put("R4", "Memory Optimized")
            .put("R5", "Memory Optimized")
            .put("R5A", "Memory Optimized with AMD Processor")
            .put("R5D", "Memory Optimized with Local Storage")
            .put("R5AD", "Memory Optimized with Local Storage and AMD Processor")
            .put("T1", "Old Burstable Performance")
            .put("T2", "Burstable Performance")
            .put("T3", "Burstable Performance")
            .put("T3A", "Burstable Performance with AMD Processor")
            .put("U-6TB1", "High Memory")
            .put("U-9TB1", "High Memory")
            .put("U-12TB1", "High Memory")
            .put("X1", "App Memory Optimized")
            .put("X1E", "DB Memory Optimized")
            .put("Z1D", "High Single Thread Performance with Local Storage")
            .build();

    @VisibleForTesting
    static final Set<String> oldGeneration = ImmutableSet.of("T1", "M1", "C1", "CC2", "M2", "CR1", "CG1", "HS1", "HI1");

    @VisibleForTesting
    static final Set<String> currentGeneration = ImmutableSet.of(
            "A1",
            "T2", "T3", "T3A",
            "M3", "M4", "M5", "M5D", "M5A", "M5AD",
            "C3", "C4", "C5", "C5D", "C5N",
            "D2",
            "F1",
            "G2", "G3", "G3S",
            "H1",
            "I2", "I3",
            "P2", "P3", "P3DN",
            "R3", "R4", "R5", "R5A", "R5D", "R5AD",
            "U-6TB1", "U-9TB1", "U-12TB1",
            "X1", "X1E",
            "Z1D");

    @VisibleForTesting
    static final Set<String> currentGenerationWithPv = ImmutableSet.of("C3", "M3");

    @VisibleForTesting
    static final Set<String> oldGenerationWithPv = ImmutableSet.of("C1", "HI1", "HS1", "M1", "M2", "T1");

    @VisibleForTesting
    static final Set<String> oldGenerationWithHvm = ImmutableSet.of("CC2", "CR1", "HI1", "HS1", "CG1");
}
