package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ScheduledExecutorService;

interface Ec2ClientFactory
{
    @NotNull
    AmazonEC2Async newAmazonEc2Async(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService);

    /**
     * @deprecated since 5.9 use {@link #newAmazonEc2Async(AwsSupportConstants.Region, AWSCredentials, ScheduledExecutorService)} instead.
     */
    @Deprecated
    @NotNull
    AmazonEC2AsyncClient newAwsAsyncClient(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService);
}
