/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullListObjectsResult
implements Iterable<S3ObjectSummary> {
    private final AmazonS3Client s3Client;
    private final String bucketName;
    private final String s3PathForArtifact;

    @Deprecated
    public FullListObjectsResult(AmazonS3Client s3Client, String bucketName, String s3PathForArtifact) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.s3PathForArtifact = s3PathForArtifact;
    }

    @Override
    @Deprecated
    public Iterator<S3ObjectSummary> iterator() {
        ObjectListing firstObjectListing = this.s3Client.listObjects(this.bucketName, this.s3PathForArtifact);
        return FullListObjectsResult.iterator(this.s3Client, firstObjectListing, null);
    }

    private static Iterator<S3ObjectSummary> iterator(final AmazonS3Client s3Client, final ObjectListing firstObjectListing, final @Nullable ObjectListingChangeCallback objectListingCallable) {
        return new Iterator<S3ObjectSummary>(){
            private ObjectListing currentObjectListing;
            private Iterator<S3ObjectSummary> objectListingIterator;
            {
                this.setCurrentObjectListing(firstObjectListing);
            }

            @Override
            public boolean hasNext() {
                return this.currentObjectListing.isTruncated() || this.objectListingIterator.hasNext();
            }

            @Override
            public S3ObjectSummary next() {
                if (!this.objectListingIterator.hasNext() && this.currentObjectListing.isTruncated()) {
                    this.setCurrentObjectListing(s3Client.listNextBatchOfObjects(this.currentObjectListing));
                }
                return this.objectListingIterator.next();
            }

            @Override
            public void remove() {
                this.objectListingIterator.remove();
            }

            private void setCurrentObjectListing(ObjectListing objectListing) {
                this.currentObjectListing = objectListing;
                this.objectListingIterator = this.currentObjectListing.getObjectSummaries().iterator();
                if (objectListingCallable != null) {
                    objectListingCallable.onNewObjectListing(objectListing);
                }
            }
        };
    }

    public static ContinuousObjectListing listObjects(@NotNull AmazonS3Client s3Client, String bucketName, String s3PathForArtifact, @Nullable ObjectListingChangeCallback objectListingCallable) {
        return new ContinuousObjectListing(s3Client, new ListObjectsRequest().withBucketName(bucketName).withPrefix(s3PathForArtifact));
    }

    public static ContinuousObjectListing listObjects(AmazonS3Client s3Client, ListObjectsRequest listObjectsRequest) {
        return new ContinuousObjectListing(s3Client, listObjectsRequest);
    }

    @NotThreadSafe
    public static class ContinuousObjectListing {
        private final AmazonS3Client s3Client;
        private final ListObjectsRequest listObjectsRequest;
        private volatile Set<String> commonPrefixes;
        private final ImmutableSet.Builder<String> truncatedCommonPrefixes = ImmutableSet.builder();

        public ContinuousObjectListing(AmazonS3Client s3Client, ListObjectsRequest listObjectsRequest) {
            this.s3Client = s3Client;
            this.listObjectsRequest = listObjectsRequest;
        }

        public Iterable<S3ObjectSummary> getS3ObjectSummaries() {
            final ObjectListing firstObjectListing = this.s3Client.listObjects(this.listObjectsRequest);
            final ObjectListingChangeCallback objectListingCallable = new ObjectListingChangeCallback(){

                @Override
                public void onNewObjectListing(ObjectListing objectListing) {
                    truncatedCommonPrefixes.addAll((Iterable)objectListing.getCommonPrefixes());
                    if (!objectListing.isTruncated()) {
                        commonPrefixes = (Set)truncatedCommonPrefixes.build();
                    }
                }
            };
            return new Iterable<S3ObjectSummary>(){

                @Override
                public Iterator<S3ObjectSummary> iterator() {
                    return FullListObjectsResult.iterator(s3Client, firstObjectListing, objectListingCallable);
                }
            };
        }

        public Iterable<String> getCommonPrefixes() {
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return this.lazyCommonPrefixesIterator();
                }
            };
        }

        private Iterator<String> lazyCommonPrefixesIterator() {
            return new Iterator<String>(){
                private final Supplier<Iterator<String>> iterator = Suppliers.memoize((Supplier)new Supplier<Iterator<String>>(){

                    public Iterator<String> get() {
                        if (commonPrefixes == null) {
                            Iterables.size(this.getS3ObjectSummaries());
                        }
                        return commonPrefixes.iterator();
                    }
                });

                @Override
                public boolean hasNext() {
                    return ((Iterator)this.iterator.get()).hasNext();
                }

                @Override
                public String next() {
                    return (String)((Iterator)this.iterator.get()).next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static interface ObjectListingChangeCallback {
        public void onNewObjectListing(ObjectListing var1);
    }
}

