package com.atlassian.aws.utils;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;

public class Eithers
{
    public static <E extends Throwable, T> Pair<E, T> right(@NotNull final T right)
    {
        Objects.requireNonNull(right);
        return ImmutablePair.of(null, right);
    }

    public static <E extends Throwable, T> Pair<E, T> left(@NotNull final E left)
    {
        Objects.requireNonNull(left);
        return ImmutablePair.of(left, null);
    }

    @NotNull
    public static <E extends Throwable, T> T getOrThrow(final Pair<E, T> either) throws E
    {
        final E left = either.getLeft();
        if (left!=null)
        {
            throw left;
        }
        return either.getRight();
    }

    public static <E extends Throwable, T> boolean isRight(final Pair<E, T> either)
    {
        return either.getLeft()==null;
    }
}
