package com.atlassian.aws.ec2.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Encapsulates VPC string id.
 */
public class VpcId extends ResourceId<VpcId>
{
    private static final VpcId NO_VPC = new VpcId(false);

    public VpcId(@NotNull final String id)
    {
        super(id);
        Preconditions.checkArgument(id.startsWith("vpc-"));
    }

    private VpcId(final boolean b)
    {
        super("");
    }

    public boolean isUndefined()
    {
        return this == NO_VPC;
    }

    public static VpcId from(@Nullable final String vpcId)
    {
        return StringUtils.isBlank(vpcId) ? NO_VPC : new VpcId(vpcId);
    }
}
