package com.atlassian.aws.ec2.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Encapsulates a spot fleet request string id.
 */
public class SpotFleetRequestId extends ResourceId<SpotFleetRequestId>
{
    public SpotFleetRequestId(@NotNull final String id)
    {
        super(id);
        Preconditions.checkArgument(isValid(id));
    }

    public static boolean isValid(@Nullable final CharSequence id)
    {
        return StringUtils.startsWith(id, "sfr-");
    }

    public static SpotFleetRequestId from(@NotNull  final String spotRequestId)
    {
        return new SpotFleetRequestId(spotRequestId);
    }
}
