package com.atlassian.aws.ec2.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;

/**
 * Encapsulates instance id.
 */
public class InstanceId extends ResourceId<InstanceId>
{
    private InstanceId(final String id)
    {
        super(id);

        Preconditions.checkArgument(id.startsWith("i-"));
    }

    public static InstanceId from(final String id)
    {
        return new InstanceId(id);
    }

    public static Iterable<InstanceId> from(final Iterable<String> ids)
    {
        return ResourceId.from(ids, InstanceId::from);
    }
}
