package com.atlassian.aws.ec2.caches;


import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.AwsOmeCache;
import org.apache.log4j.Logger;

import java.time.Duration;
import java.util.List;

public class VpcCache extends AwsOmeCache<Vpc>
{
    private static final Logger log = Logger.getLogger(VpcCache.class);

    private final AmazonEC2Async ec2Client;

    public VpcCache(final AmazonEC2Async ec2Client, final Duration maximumDataAge)
    {
        super(log, maximumDataAge);
        this.ec2Client = ec2Client;
    }

    public VpcCache(final AmazonEC2Async ec2Client)
    {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Vpc> refreshAllData()
    {
        final DescribeVpcsResult describeVpcsResult = ec2Client.describeVpcs();
        return describeVpcsResult.getVpcs();
    }

    @Override
    protected String toResourceId(final Vpc vpc)
    {
        return vpc.getVpcId();
    }

    @Override
    protected void onResourceLookupFailure(final String resourceId)
    {
        throw new Ec2CacheMissException(resourceId, AmazonServiceErrorCode.INVALID_VPC_ID_NOT_FOUND);
    }
}
