package com.atlassian.aws.ec2.awssdk.launch;

import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.AvailabilityZoneChooser;
import com.atlassian.aws.ec2.InstanceLaunchConfiguration;
import com.atlassian.aws.ec2.InstanceStatus;
import com.atlassian.aws.ec2.SubnetChooser;
import com.atlassian.aws.ec2.awssdk.InstanceLauncher;
import org.apache.log4j.Logger;

public class InstanceLauncherFactory
{
    private static final Logger log = Logger.getLogger(InstanceLauncherFactory.class);

    private final SubnetChooser subnetChooser;
    final AWSAccount awsAccount;

    public InstanceLauncherFactory(final AWSAccount awsAccount)
    {
        this.awsAccount = awsAccount;
        subnetChooser = new SubnetChooser(new AvailabilityZoneChooser(), awsAccount);
    }

    public InstanceLauncher newLauncher(final InstanceLaunchConfiguration instanceConfiguration, final InstanceStatus instanceStatus)
    {
        return instanceConfiguration.getSpotInstanceBid()>0 ? newSpotInstanceLauncher(instanceConfiguration, instanceStatus) : newOnDemandInstanceLauncher(instanceConfiguration, instanceStatus);
    }

    public InstanceLauncher newOnDemandInstanceLauncher(final InstanceLaunchConfiguration instanceConfiguration, final InstanceStatus instanceStatus)
    {
        return new AwsInstanceLauncher(awsAccount, subnetChooser, instanceConfiguration, instanceStatus);
    }

    public InstanceLauncher newSpotInstanceLauncher(final InstanceLaunchConfiguration instanceConfiguration, final InstanceStatus instanceStatus)
    {
        final InstanceLauncher fallbackLauncher = newOnDemandInstanceLauncher(instanceConfiguration, instanceStatus);
        return new AwsSpotInstanceLauncher(awsAccount, subnetChooser, instanceConfiguration, instanceStatus, fallbackLauncher);
//        return new AwsSpotFleetLauncher(awsAccount, subnetChooser, instanceConfiguration, instanceStatus, fallbackLauncher);
    }
}
