package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.AccountAttribute;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public class Ec2AccountAttributes
{

    private static final String DEFAULT_VPC_ID_USED_ON_CLASSIC_EC2 = "none";

    private static enum AccountAttributes implements AwsSupportConstants.NameProvider
    {
        DEFAULT_VPC("default-vpc"),
        SUPPORTED_PLATFORMS("supported-platforms");

        private final String name;

        AccountAttributes(String name)
        {
            this.name = name;
        }

        @Override
        public String getName()
        {
            return name;
        }
    }

    private static final Logger log = Logger.getLogger(Ec2AccountAttributes.class);

    private Ec2AccountAttributes()
    {
    }

    @NotNull
    public static String getDefaultVpc(final Map<String, AccountAttribute> accountAttributes)
    {
        final AccountAttribute accountAttribute = accountAttributes.get(AccountAttributes.DEFAULT_VPC.getName());
        if (accountAttribute==null)
        {
            return "";
        }

        final String defaultVpcId = Iterables.getOnlyElement(accountAttribute.getAttributeValues()).getAttributeValue();
        return isClassicEc2Account(defaultVpcId) ? "" : defaultVpcId;
    }

    private static boolean isClassicEc2Account(String defaultVpcId)
    {
        return defaultVpcId.equalsIgnoreCase(DEFAULT_VPC_ID_USED_ON_CLASSIC_EC2);
    }
}
