package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.Instance;
import org.jetbrains.annotations.NotNull;

/**
 * <p>A remote {@link EC2Instance}.</p>
 */
public interface RemoteEC2Instance extends EC2Instance
{
    @Override
    String getInstanceId();

    /**
     * <p>Terminate this EC2 instance, asynchronously.<p>
     */
    void asyncTerminate();

    /**
     * @return true if the instance is being terminated
     */
    boolean isBeingTerminated();

    /**
     * Start the instance
     */
    void start();

    /**
     * Asynchronously adds an AWS tag to the instance.
     */
    void addTag(@NotNull String key, @NotNull String value);

    InstanceStatus getInstanceStatus();

    InstanceLaunchConfiguration getInstanceConfiguration();

    /**
     * Method allowing to recreate instance's state after Bamboo server restart.
     * @param instance
     */
    void reconnectToRunningInstance(@NotNull Instance instance);
}
