package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants.InstanceStateName;
import com.atlassian.aws.ec2.model.SubnetId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InstanceReservationDescription
{
    String getInstanceId();

    String getAvailabilityZone();

    @Nullable
    SubnetId getSubnet();

    /**
     * Returns best known instance address - in order of preference:
     *  - the public IP address (from EIP, if assigned)
     *  - the private IP address.
     */
    @NotNull
    String getAddress();

    @Nullable
    InstanceType getInstanceType();

    /**
     * Returns best known instance host name - in order of preference:
     *  - the public DNS name (from EIP, if assigned)
     *  - the public IP address (from EIP, if assigned)
     *  - the private DNS name
     *  - the private IP address.
     */
    @NotNull
    String getHostname();

    InstanceStateName getState();

    String getStateDescription();
}
