package com.atlassian.aws.ec2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import java.util.Map;
import java.util.Set;

class InstanceFamilyData {
    static final Map<String, String> familyNames = ImmutableMap.<String, String>builder()
            .put("C1", "Old Compute Optimized")
            .put("C3", "Compute Optimized")
            .put("C4", "Compute Optimized")
            .put("C5", "Compute Optimized")
            .put("CC2", "Old Cluster Compute Optimized")
            .put("CG1", "Old Cluster GPU")
            .put("CR1", "Old Memory Optimized Cluster")
            .put("D2", "Storage Optimized HDD")
            .put("F1", "FPGA Accelerated")
            .put("G2", "Accelerated Computing GPU")
            .put("G3", "Graphics Intensive")
            .put("H1", "Storage Optimized")
            .put("HI1", "Old Storage Optimized")
            .put("HS1", "Old Storage Optimized")
            .put("I2", "Storage Optimized")
            .put("I3", "Storage Optimized SSD")
            .put("M1", "Old General Purpose")
            .put("M2", "Old Memory Optimized")
            .put("M3", "General Purpose")
            .put("M4", "General Purpose")
            .put("M5", "Latest General Purpose")
            .put("P2", "Accelerated Computing GPU")
            .put("P3", "Latest Accelerated Computing GPU")
            .put("R3", "Memory Optimized")
            .put("R4", "Memory Optimized")
            .put("T1", "Old Burstable Performance")
            .put("T2", "Burstable Performance")
            .put("X1", "App Memory Optimized")
            .put("X1E", "DB Memory Optimized")
            .build();

    @VisibleForTesting
    static final Set<String> oldGeneration = ImmutableSet.of("T1", "M1", "C1", "CC2", "M2", "CR1", "CG1", "HS1", "HI1");

    @VisibleForTesting
    static final Set<String> currentGeneration = ImmutableSet.of(
            "T2",
            "M3", "M4", "M5",
            "C3", "C4", "C5",
            "D2",
            "F1",
            "G2", "G3",
            "H1",
            "I2", "I3",
            "P2", "P3",
            "R3", "R4",
            "X1", "X1E");

    @VisibleForTesting
    static final Set<String> currentGenerationWithPv = ImmutableSet.of("C3", "M3");

    @VisibleForTesting
    static final Set<String> oldGenerationWithPv = ImmutableSet.of("C1", "HI1", "HS1", "M1", "M2", "T1");

    @VisibleForTesting
    static final Set<String> oldGenerationWithHvm = ImmutableSet.of("CC2", "CR1", "HI1", "HS1", "CG1");
}
