package com.atlassian.aws.ec2;

import org.jetbrains.annotations.Nullable;

/**
 * <p>A listener to changes in the state of one or more {@link RemoteEC2Instance}s.</p>
 */
public interface EC2InstanceListener
{

    /**
     * <p>Notification that the {@link EC2InstanceState} of an observed {@link RemoteEC2Instance} has changed.</p>
     *
     * @param ec2Instance   The {@link RemoteEC2Instance} that has undergone the change in {@link EC2InstanceState}.
     * @param previousState The previous {@link EC2InstanceState} of <code>ec2Instance</code>.
     * @param newState      The new {@link EC2InstanceState} of <code>ec2Instance</code>.
     * @param details       Details accompanying the state change, or <code>null</code> if none are available.  Suitable
     *                      for inclusion in a user-visible event log.
     * @param throwable     The {@link Throwable} that caused the state change, if applicable.  Othewise,
     *                      <code>null</code>.
     */
    void ec2InstanceStateChanged(final RemoteEC2Instance ec2Instance, final EC2InstanceState previousState,
                                 final EC2InstanceState newState, @Nullable final String details, @Nullable final Throwable throwable);

    void onInstanceAddressChange(final String previousAddress, final String newAddress);
}
