package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import org.jetbrains.annotations.NotNull;

public class AmazonEc2Utils
{
    public static void ensureInboundTrafficIsAllowed(final AmazonEC2 amazonEc2, @NotNull final SecurityGroup group, @NotNull final Protocol protocol, @NotNull final String cidrIpRange, final int port)
    {
        final boolean matchFound = !EC2Utils.getMatchingIpPermissions(group, protocol, cidrIpRange, port).isEmpty();
        if (matchFound)
        {
            return;
        }

        final IpPermission ipPermission = new IpPermission()
                .withIpProtocol(protocol.getValue())
                .withFromPort(port)
                .withToPort(port)
                .withIpRanges(cidrIpRange);

        final AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest =
                new AuthorizeSecurityGroupIngressRequest()
                        .withGroupId(group.getGroupId())
                        .withIpPermissions(ipPermission);
        amazonEc2.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
    }
}
