package com.atlassian.aws;

import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/**
 * Creates proxies that time executions of invoked methods.
 */
final class CallTimingProxy
{
    private CallTimingProxy()
    {
    }

    @NotNull
    static <I, T extends I> I wrap(final T timedDelegate, final Class<I> delegateInterface)
    {
        final Logger log = Logger.getLogger("timed." + timedDelegate.getClass().getName());

        final InvocationHandler handler = new InvocationHandler()
        {
            @Override
            public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable
            {
                final long start = System.currentTimeMillis();
                try
                {
                    log.trace("Invoking: " + method);
                    return method.invoke(timedDelegate, args);
                }
                catch (final InvocationTargetException e)
                {
                    throw e.getCause();
                }
                finally
                {
                    long end = System.currentTimeMillis();
                    log.debug(method.getName() + " took " + (end-start) + "ms ");
                }
            }
        };

        return (T) Proxy.newProxyInstance(timedDelegate.getClass().getClassLoader(), new Class[]{delegateInterface}, handler);
    }
}
