package com.atlassian.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;

import java.util.concurrent.ScheduledExecutorService;

public class AWSManagerImpl implements AWSManager
{
    private final Ec2ClientFactory ec2ClientFactory;
    private final ScheduledExecutorService scheduledExecutorService;

    public AWSManagerImpl(final Ec2ClientFactory ec2ClientFactory,
                          final ScheduledExecutorService scheduledExecutorService)
    {
        this.ec2ClientFactory = ec2ClientFactory;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public AWSAccount getAWSAccount(final AwsSupportConstants.Region region, final String awsAccessId, final String awsSecretKey)
    {
        final AWSCredentials awsCredentials = new BasicAWSCredentials(awsAccessId, awsSecretKey);
        return getAWSAccount(region, awsCredentials);
    }

    public AWSAccount getAWSAccount(final AwsSupportConstants.Region region, final AWSCredentials credentials)
    {
        return new AWSAccountImpl(ec2ClientFactory, scheduledExecutorService, credentials, region);
    }
}
