/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import java.security.KeyStore;
import java.util.Base64;

public class JsonUtils {
    public static Gson gson;

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)gson.fromJson(json, classOfT);
    }

    public static String toJson(Object userData) {
        return gson.toJson(userData);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(KeyStore.class, (Object)new KeyStoreMarshaller());
        gson = builder.create();
    }

    private static class KeyStoreMarshaller
    implements JsonSerializer<KeyStore>,
    JsonDeserializer<KeyStore> {
        static final String KEY_STORE_PASSWORD = "bamboo";

        private KeyStoreMarshaller() {
        }

        public JsonElement serialize(KeyStore keyStore, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((JsonElement)new JsonPrimitive(keyStore.getType()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                keyStore.store(byteArrayOutputStream, KEY_STORE_PASSWORD.toCharArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            String keyStoreContents = Base64.getMimeEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            jsonArray.add((JsonElement)new JsonPrimitive(keyStoreContents));
            return jsonArray;
        }

        public KeyStore deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray array = jsonElement.getAsJsonArray();
            try {
                JsonElement keyStoreType = array.get(0);
                JsonElement keyStoreContent = array.get(1);
                KeyStore keyStore = KeyStore.getInstance(keyStoreType.getAsString());
                byte[] decoded = Base64.getMimeDecoder().decode(keyStoreContent.getAsString());
                keyStore.load(new ByteArrayInputStream(decoded), KEY_STORE_PASSWORD.toCharArray());
                return keyStore;
            }
            catch (Exception e) {
                throw new JsonParseException("Could not deserialize keystore", (Throwable)e);
            }
        }
    }
}

