/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.EC2Instance;
import com.atlassian.aws.utils.URLFetcherUtils;
import java.io.IOException;

class LocalEC2InstanceImpl
implements EC2Instance {
    private static final String INSTANCE_ID_URL = "http://169.254.169.254/2008-02-01/meta-data/instance-id";
    private String instanceId;

    LocalEC2InstanceImpl() {
    }

    @Override
    public synchronized String getInstanceId() throws IOException {
        if (this.instanceId == null) {
            this.instanceId = this.fetchInstanceId();
        }
        return this.instanceId;
    }

    private String fetchInstanceId() {
        try {
            return URLFetcherUtils.getURLFetcher().fetchString(INSTANCE_ID_URL);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

