/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.EC2Instance;
import com.atlassian.aws.ec2.LocalEC2InstanceImpl;
import com.atlassian.aws.utils.JsonUtils;
import com.atlassian.aws.utils.URLFetcherUtils;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class Ec2UtilsThin {
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    static final String API_BASE_URL = "http://169.254.169.254/2008-02-01/";
    static final String META_DATA_BASE_URL = "http://169.254.169.254/2008-02-01/meta-data/";
    static final String USER_DATA_URL = "http://169.254.169.254/2008-02-01/user-data";

    private Ec2UtilsThin() {
    }

    @NotNull
    public static EC2Instance getLocalEC2Instance() throws IOException {
        return new LocalEC2InstanceImpl();
    }

    public static <T> T getUserData(Class<T> aClass) throws IOException {
        boolean shouldAttemptDecompression = true;
        try {
            return JsonUtils.fromJson(URLFetcherUtils.fetchString(USER_DATA_URL, CHARSET_UTF_8, shouldAttemptDecompression), aClass);
        }
        catch (JsonSyntaxException e) {
            shouldAttemptDecompression = false;
            return JsonUtils.fromJson(URLFetcherUtils.fetchString(USER_DATA_URL, CHARSET_UTF_8, shouldAttemptDecompression), aClass);
        }
    }
}

