/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.rest.model;

import com.atlassian.audit.entity.AuditCoverageConfig;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.EffectiveCoverageLevel;
import com.atlassian.audit.rest.model.CoverageAreaJson;
import com.atlassian.audit.rest.model.EffectiveCoverageLevelJson;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.stream.Collectors;

public class AuditCoverageConfigJson {
    private final Map<CoverageAreaJson, EffectiveCoverageLevelJson> levelByArea;

    public AuditCoverageConfigJson(AuditCoverageConfig config) {
        this(config.getLevelByArea().entrySet().stream().collect(Collectors.toMap(e -> CoverageAreaJson.fromCoverageArea((CoverageArea)e.getKey()), e -> EffectiveCoverageLevelJson.fromCoverageLevel((EffectiveCoverageLevel)e.getValue()))));
    }

    @JsonCreator
    public AuditCoverageConfigJson(@JsonProperty(value="levelByArea") Map<CoverageAreaJson, EffectiveCoverageLevelJson> levelByArea) {
        this.levelByArea = levelByArea;
    }

    @JsonProperty(value="levelByArea")
    public Map<CoverageAreaJson, EffectiveCoverageLevelJson> getLevelByArea() {
        return this.levelByArea;
    }

    @JsonIgnore
    public AuditCoverageConfig toCoverageConfig() {
        return new AuditCoverageConfig(this.levelByArea.entrySet().stream().collect(Collectors.toMap(e -> ((CoverageAreaJson)((Object)((Object)e.getKey()))).toCoverageArea(), e -> ((EffectiveCoverageLevelJson)((Object)((Object)e.getValue()))).toEffectiveCoverageLevel())));
    }
}

