/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.rest.v1.utils;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.rest.model.AuditAttributeJson;
import com.atlassian.audit.rest.model.AuditAuthorJson;
import com.atlassian.audit.rest.model.AuditEntityJson;
import com.atlassian.audit.rest.model.AuditResourceJson;
import com.atlassian.audit.rest.model.AuditTypeJson;
import com.atlassian.audit.rest.model.ChangedValueJson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AuditEntitySerializer {
    private static final ObjectMapper mapper = AuditEntitySerializer.constructObjectMapper();

    private AuditEntitySerializer() {
    }

    @Nonnull
    public static String serialize(@Nonnull AuditEntity auditEntity) {
        Objects.requireNonNull(auditEntity, "auditEntity");
        try {
            return mapper.writeValueAsString((Object)auditEntity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static ChangedValueJson toJson(ChangedValue changedValue) {
        return new ChangedValueJson(changedValue.getKey(), changedValue.getI18nKey(), changedValue.getFrom(), changedValue.getTo());
    }

    public static AuditEntityJson toJson(AuditEntity entity, TimeZone timeZone) {
        return new AuditEntityJson(entity.getTimestamp().atZone(timeZone.toZoneId()), AuditEntitySerializer.toJson(entity.getAuthor()), AuditEntitySerializer.toJson(entity.getAuditType()), entity.getAffectedObjects().stream().map(o -> AuditEntitySerializer.toJson(o)).collect(Collectors.toList()), entity.getChangedValues().stream().map(AuditEntitySerializer::toJson).collect(Collectors.toList()), entity.getSource(), entity.getSystem(), entity.getNode(), entity.getMethod(), entity.getExtraAttributes().stream().map(AuditEntitySerializer::toJson).sorted(Comparator.comparing(AuditAttributeJson::getName)).collect(Collectors.toList()));
    }

    public static AuditAttributeJson toJson(AuditAttribute auditAttribute) {
        return new AuditAttributeJson(auditAttribute.getNameI18nKey(), auditAttribute.getName(), auditAttribute.getValue());
    }

    public static AuditAuthorJson toJson(AuditAuthor author) {
        return new AuditAuthorJson(author.getName() != null ? author.getName() : AuditAuthor.UNKNOWN_AUTHOR.getName(), author.getType(), author.getId(), author.getUri(), "");
    }

    public static AuditTypeJson toJson(AuditType auditType) {
        return new AuditTypeJson(auditType.getCategoryI18nKey(), auditType.getCategory(), auditType.getActionI18nKey(), auditType.getAction());
    }

    public static AuditResourceJson toJson(AuditResource auditResource) {
        return new AuditResourceJson(auditResource.getName(), auditResource.getType(), auditResource.getUri(), auditResource.getId());
    }

    private static ObjectMapper constructObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JavaTimeModule module = new JavaTimeModule();
        module.addSerializer(Instant.class, (JsonSerializer)new JsonSerializer<Instant>(){

            public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("epochSecond", instant.getEpochSecond());
                jsonGenerator.writeNumberField("nano", instant.getNano());
                jsonGenerator.writeEndObject();
            }
        });
        return objectMapper.registerModule((Module)module);
    }
}

