/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.search;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.ao.dao.entity.AoAuditEntity;
import com.atlassian.audit.ao.dao.entity.AoAuditEntityAction;
import com.atlassian.audit.coverage.SingleValueCache;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.java.ao.Query;

public class ActionsProvider {
    private static final int ACTION_LIMIT = 10000;
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;
    private final SingleValueCache<Set<String>> actionsCache;

    public ActionsProvider(ActiveObjects ao, TransactionTemplate transactionTemplate, int refreshIntervalInSeconds) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.actionsCache = new SingleValueCache<Set>(this::queryDistinctActions, (long)refreshIntervalInSeconds, TimeUnit.SECONDS);
    }

    @Nonnull
    private Set<String> queryDistinctActions() {
        return Arrays.stream((Object[])this.transactionTemplate.execute(() -> (AoAuditEntityAction[])this.ao.find(AoAuditEntityAction.class, Query.select((String)"ACTION").distinct().limit(10000)))).map(AoAuditEntity::getAction).collect(Collectors.toSet());
    }

    public List<String> getActions() {
        return this.actionsCache.get().stream().sorted().collect(Collectors.toList());
    }
}

