/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.frontend.data;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.frontend.data.AuditKbArticleData;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class AuditKbArticleDataProvider
implements WebResourceDataProvider {
    private static final String PROP_FILE_PATH = "/atlassian-audit-frontend-settings.properties";
    private static final String PREFIX_KEY = "atlassian.audit.frontend";
    private static final String KB_FEATURE_KEY = "atlassian.audit.frontend.kb.feature.";
    private static final String KB_REFERENCE_KEY = "atlassian.audit.frontend.kb.reference.";
    private static final String KB_INTEGRATIONS_KEY = "atlassian.audit.frontend.kb.integrations.";
    private static final String KB_DATABASE_RETENTION_KEY = "atlassian.audit.frontend.kb.databaseRetention";
    private final ApplicationProperties applicationProperties;
    private final Properties auditSettings;
    private final ObjectMapper objectMapper;

    public AuditKbArticleDataProvider(ApplicationProperties applicationProperties, ObjectMapper objectMapper) throws IOException {
        this(applicationProperties, objectMapper, PROP_FILE_PATH);
    }

    @VisibleForTesting
    protected AuditKbArticleDataProvider(ApplicationProperties applicationProperties, ObjectMapper objectMapper, String propFilePath) throws IOException {
        this.applicationProperties = applicationProperties;
        this.objectMapper = objectMapper;
        try (InputStream inputStream = this.getClass().getResourceAsStream(propFilePath);){
            this.auditSettings = new Properties();
            this.auditSettings.load(inputStream);
        }
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.objectMapper.writeValue(writer, (Object)this.getData());
            }
            catch (Exception e) {
                throw new JsonMappingException(e.getMessage(), (Throwable)e);
            }
        };
    }

    private AuditKbArticleData getData() {
        String fallbackUrl = "http://www.atlassian.com/";
        return new AuditKbArticleData(URI.create(this.auditSettings.getProperty(KB_FEATURE_KEY + this.getProductName(), fallbackUrl)), URI.create(this.auditSettings.getProperty(KB_REFERENCE_KEY + this.getProductName(), fallbackUrl)), URI.create(this.auditSettings.getProperty(KB_INTEGRATIONS_KEY + this.getProductName(), fallbackUrl)), URI.create(this.auditSettings.getProperty(KB_DATABASE_RETENTION_KEY, fallbackUrl)));
    }

    private String getProductName() {
        return this.applicationProperties.getPlatformId();
    }
}

