/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.frontend.data;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.ao.service.CachedCountService;
import com.atlassian.audit.coverage.ProductLicenseChecker;
import com.atlassian.audit.frontend.data.AuditEventsViewData;
import com.atlassian.audit.search.ActionsProvider;
import com.atlassian.audit.search.CategoriesProvider;
import com.atlassian.audit.service.TranslationService;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventsViewDataProvider
implements WebResourceDataProvider {
    protected static final String PROP_FILE_PATH = "/atlassian-audit-frontend-settings.properties";
    private static final String PREFIX_KEY = "atlassian.audit.frontend";
    private static final String TITLE_KEY = "atlassian.audit.frontend.title";
    private static final String LICENSE_DC_KEY = ".dc";
    private static final String LICENSE_SERVER_KEY = ".server";
    private static final String AFFECTED_OBJECTS_PLACEHOLDER = "atlassian.audit.frontend.affectedObjects.placeholder.";
    private static final String AFFECTED_OBJECTS_TYPE = "atlassian.audit.frontend.affectedObjects.type.";
    private static final String DELEGATED_VIEW_FILTER = "atlassian.audit.frontend.delegatedView.filter.";
    private static final String SPLIT = ",";
    private static final Logger log = LoggerFactory.getLogger(AuditEventsViewDataProvider.class);
    private final TranslationService translationService;
    private final ApplicationProperties applicationProperties;
    private final ProductLicenseChecker licenseChecker;
    private final Properties auditSettings;
    private final ObjectMapper objectMapper;
    private final TimeZoneManager timeZoneManager;
    private final CategoriesProvider categoriesProvider;
    private final ActionsProvider actionsProvider;
    private final CachedCountService cachedCountService;

    public AuditEventsViewDataProvider(ProductLicenseChecker licenseChecker, ApplicationProperties applicationProperties, TranslationService translationService, ObjectMapper objectMapper, TimeZoneManager timeZoneManager, CategoriesProvider categoriesProvider, ActionsProvider actionsProvider, CachedCountService cachedCountService) throws IOException {
        this(licenseChecker, applicationProperties, translationService, objectMapper, timeZoneManager, PROP_FILE_PATH, categoriesProvider, actionsProvider, cachedCountService);
    }

    @VisibleForTesting
    protected AuditEventsViewDataProvider(ProductLicenseChecker licenseChecker, ApplicationProperties applicationProperties, TranslationService translationService, ObjectMapper objectMapper, TimeZoneManager timeZoneManager, String propFilePath, CategoriesProvider categoriesProvider, ActionsProvider actionsProvider, CachedCountService cachedCountService) throws IOException {
        this.applicationProperties = applicationProperties;
        this.translationService = translationService;
        this.licenseChecker = licenseChecker;
        this.objectMapper = objectMapper;
        this.timeZoneManager = timeZoneManager;
        this.actionsProvider = actionsProvider;
        try (InputStream inputStream = this.getClass().getResourceAsStream(propFilePath);){
            this.auditSettings = new Properties();
            this.auditSettings.load(inputStream);
        }
        this.categoriesProvider = categoriesProvider;
        this.cachedCountService = cachedCountService;
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.objectMapper.writeValue(writer, (Object)this.getData());
            }
            catch (Exception e) {
                throw new JsonMappingException(e.getMessage(), (Throwable)e);
            }
        };
    }

    private AuditEventsViewData getData() {
        AuditEventsViewData eventsViewData = new AuditEventsViewData().withPageTitle(this.getI18nText(TITLE_KEY + (this.isDcLicense() ? LICENSE_DC_KEY : LICENSE_SERVER_KEY)));
        eventsViewData.withSelectiveExportEnabled(this.isDcLicense() || "conf".equals(this.getProductName())).withUserLocale(this.getUserLocale()).withUserTimeZone(this.getUserTimeZone()).withServerTimeZone(this.getServerTimeZone()).withDcFilter(this.isDcLicense()).categoryFilter(this.getCategories()).actionFilter(this.getActions()).count(this.getCount());
        eventsViewData.affectedObjectsFilters(this.getAffectedObjectFiltersForProduct());
        eventsViewData.globalAffectedObjectsFilters(this.getGlobalAffectedObjectFiltersForProduct());
        eventsViewData.delegatedAffectedObjectsFilters(this.getDelegatedViewsAffectedObjectsFilters());
        return eventsViewData;
    }

    private long getCount() {
        return this.cachedCountService.count();
    }

    private List<String> getCategories() {
        try {
            return this.categoriesProvider.getCategories();
        }
        catch (RuntimeException e) {
            log.error("Failed to get category filters", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> getActions() {
        try {
            return this.actionsProvider.getActions();
        }
        catch (RuntimeException e) {
            log.error("Failed to get action filters", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String getI18nText(String key) {
        return this.translationService.getSiteLocaleText(key);
    }

    private String getServerTimeZone() {
        return this.timeZoneManager.getDefaultTimeZone().getID();
    }

    private String getUserTimeZone() {
        return this.timeZoneManager.getUserTimeZone().getID();
    }

    private String getUserLocale() {
        return this.translationService.getUserLocale().toLanguageTag();
    }

    private boolean isDcLicense() {
        return !this.licenseChecker.isNotDcLicense();
    }

    private String getProductName() {
        return this.applicationProperties.getPlatformId();
    }

    private Collection<AuditEventsViewData.AffectedObjectsFilter> getAffectedObjectFiltersForProduct() {
        String filtersStr = this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + this.getProductName(), "");
        return Stream.of(filtersStr.split(SPLIT)).filter(str -> str != null && str.length() > 0).map(key -> new AuditEventsViewData.AffectedObjectsFilter(this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + key), this.getI18nText(AFFECTED_OBJECTS_PLACEHOLDER + key))).collect(Collectors.toList());
    }

    private Collection<String> getGlobalAffectedObjectFiltersForProduct() {
        String filtersStr = this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + this.getProductName(), "");
        return Stream.of(filtersStr.split(SPLIT)).filter(str -> str != null && str.length() > 0).map(key -> this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + key)).collect(Collectors.toList());
    }

    private Map<String, List<String>> getDelegatedViewsAffectedObjectsFilters() {
        String filtersStr = this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + this.getProductName(), "");
        return Stream.of(filtersStr.split(SPLIT)).filter(str -> str != null && str.length() > 0).collect(Collectors.toMap(key -> this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + key), key -> Stream.of(this.auditSettings.getProperty(DELEGATED_VIEW_FILTER + this.getProductName() + "." + key, "").split(SPLIT)).filter(str -> str != null && str.length() > 0).map(filter -> this.auditSettings.getProperty(AFFECTED_OBJECTS_TYPE + filter, "")).collect(Collectors.toList())));
    }
}

