package com.atlassian.audit.service;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;

import java.util.Locale;

public class DefaultTranslationService implements TranslationService {
    private final I18nResolver i18nResolver;
    private final LocaleResolver localeResolver;

    public DefaultTranslationService(I18nResolver i18nResolver, LocaleResolver localeResolver) {
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
    }

    public String getSiteLocaleText(String key) {
        return i18nResolver.getText(getSiteLocale(), key);
    }

    private Locale getSiteLocale() {
        return localeResolver.getApplicationLocale();
    }

    @Override
    public Locale getUserLocale() {
        return localeResolver.getLocale();
    }
}
