package com.atlassian.audit.rest.validation.mapper;

import com.atlassian.audit.csv.LicenseException;
import com.atlassian.audit.rest.model.ResponseErrorJson;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import java.time.Instant;
import java.util.Collections;

/**
 * Maps exceptions to responses in JAX-RS
 */
@Provider
public class LicenseExceptionMapper implements ExceptionMapper<LicenseException> {
    @Override
    public Response toResponse(LicenseException e) {
        Response.Status status = Response.Status.FORBIDDEN;
        return Response.status(status)
                .entity(new ResponseErrorJson(
                        status.getStatusCode(),
                        e.getMessage(),
                        Collections.emptyList(),
                        Instant.now().toString()
                ))
                .build();

    }
}

