package com.atlassian.audit.rest.validation.mapper;

import com.atlassian.audit.rest.model.ResponseErrorJson;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import java.time.Instant;
import java.util.Collections;

/**
 * Maps exceptions to responses in JAX-RS
 */
@Provider
public class IllegalArgumentExceptionMapper implements ExceptionMapper<IllegalArgumentException> {

    @Override
    public Response toResponse(IllegalArgumentException e) {
        return Response.status(Response.Status.BAD_REQUEST)
                .entity(new ResponseErrorJson(
                        Response.Status.BAD_REQUEST.getStatusCode(),
                        e.getMessage(),
                        Collections.emptyList(),
                        Instant.now().toString()))
                .build();
    }
}
