package com.atlassian.audit.rest.validation;

import com.atlassian.audit.rest.model.ErrorDescription;

import java.util.ArrayList;
import java.util.List;

// Data structure that stores multiple errors
public class ValidationResult {
    private final List<ErrorDescription> errors = new ArrayList<>();

    public ValidationResult() {
    }

    public ValidationResult(final String code, final String title) {
        this.add(code, title);
    }

    public void add(final String code, final String title) {
        errors.add(new ErrorDescription(code, title));
    }

    public void addAll(final ValidationResult result) {
        result.getErrors().forEach(error -> add(error.getKey(), error.getMessage()));
    }

    public void addAll(final List<ErrorDescription> results) {
        results.forEach(error -> add(error.getKey(), error.getMessage()));
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public List<ErrorDescription> getErrors() {
        return errors;
    }
}
