package com.atlassian.audit.policy;

import com.atlassian.audit.broker.AuditPolicy;
import com.atlassian.audit.coverage.CachingAuditCoverageService;
import com.atlassian.audit.entity.AuditCoverageConfig;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.EffectiveCoverageLevel;

import javax.annotation.Nonnull;

/**
 * An implementation of {@link AuditPolicy} which respects current coverage configuration.
 */
public class CoverageBasedAuditPolicy implements AuditPolicy {

    private final CachingAuditCoverageService coverageConfigService;

    public CoverageBasedAuditPolicy(CachingAuditCoverageService coverageConfigService) {
        this.coverageConfigService = coverageConfigService;
    }

    @Override
    public boolean pass(@Nonnull AuditEntity entity) {
        final AuditCoverageConfig currentConfig = coverageConfigService.getConfig();
        final AuditType type = entity.getAuditType();
        final EffectiveCoverageLevel configuredLevel = currentConfig.getLevelByArea().get(type.getArea());

        return configuredLevel.shouldAllow(type.getLevel());
    }
}
