package com.atlassian.audit.plugin.upgrade.task;

import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.plugin.upgrade.AuditUpgradeTask;
import com.atlassian.audit.spi.migration.LegacyRetentionConfigProvider;
import com.atlassian.sal.api.message.Message;

import java.util.Collection;

import static java.util.Collections.emptySet;
import static java.util.Objects.requireNonNull;

/**
 * Migrate current retention config of host product into Advanced auditing
 */
public class UpgradeTask2MigrateLegacyRetentionConfig extends AuditUpgradeTask {
    private static final int BUILD_NUMBER = 2;
    private final AuditRetentionConfigService auditRetentionConfigService;
    private final LegacyRetentionConfigProvider configProvider;

    public UpgradeTask2MigrateLegacyRetentionConfig(AuditRetentionConfigService auditRetentionConfigService,
                                                    LegacyRetentionConfigProvider configProvider) {
        this.auditRetentionConfigService = requireNonNull(auditRetentionConfigService);
        this.configProvider = requireNonNull(configProvider);
    }

    @Override
    public int getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Migrate existing auditing retention configurations";
    }

    @Override
    public Collection<Message> doUpgrade() throws Exception {
        configProvider.get()
                .ifPresent(auditRetentionConfigService::updateConfig);
        return emptySet();
    }
}
