package com.atlassian.audit.plugin.upgrade;

import java.util.ArrayList;
import java.util.Collection;

import static java.util.Collections.unmodifiableCollection;
import static java.util.Objects.requireNonNull;

public class UpgradeTaskCollector {
    private final Collection<AuditUpgradeTask> upgradeTasks;

    public UpgradeTaskCollector(Collection<AuditUpgradeTask> upgradeTasks) {
        this.upgradeTasks = new ArrayList<>(requireNonNull(upgradeTasks));
    }

    public Collection<AuditUpgradeTask> findAll() {
        return unmodifiableCollection(upgradeTasks);
    }
}
