package com.atlassian.audit.plugin.upgrade;

import com.atlassian.upgrade.spi.UpgradeTask;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;

import javax.annotation.Nonnull;
import java.util.Collection;

import static java.util.Objects.requireNonNull;
import static java.util.stream.Collectors.toList;

/**
 * Atlassian-upgrade-task-framework upgrade task factory for atlassian-audit plugin
 */
public class AuditUpgradeTaskFactory implements UpgradeTaskFactory {
    private final UpgradeTaskCollector upgradeTaskCollector;

    public AuditUpgradeTaskFactory(UpgradeTaskCollector upgradeTaskCollector) {
        this.upgradeTaskCollector = requireNonNull(upgradeTaskCollector);
    }

    @Override
    public String getProductDisplayName() {
        return "Advanced Auditing";
    }

    @Override
    public String getProductMinimumVersion() {
        return "1.0.0";
    }

    @Override
    public int getMinimumBuildNumber() {
        return 0;
    }

    @Nonnull
    @Override
    public Collection<UpgradeTask> getAllUpgradeTasks() {
        return upgradeTaskCollector.findAll()
                .stream()
                .map(UtfUpgradeTaskAdaptor::new)
                .collect(toList());
    }
}
