package com.atlassian.audit.plugin.configuration;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.importOsgiService;

@Configuration
public class FrontendConfiguration {
    @Bean
    public LicenseHandler licenseHandler() {
        return importOsgiService(LicenseHandler.class);
    }

    @Bean
    public DarkFeatureManager featureManager() {
        return importOsgiService(DarkFeatureManager.class);
    }

    @Bean
    public LoginUriProvider uriProvider() {
        return importOsgiService(LoginUriProvider.class);
    }

    @Bean
    public SoyTemplateRenderer soyTemplateRenderer() {
        return importOsgiService(SoyTemplateRenderer.class);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return importOsgiService(LocaleResolver.class);
    }

    @Bean
    public TimeZoneManager timeZoneManager() {
        return importOsgiService(TimeZoneManager.class);
    }
}
