package com.atlassian.audit.plugin.configuration;

import com.atlassian.audit.ao.consumer.DatabaseAuditConsumer;
import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.plugin.configuration.condition.NonJira;
import com.atlassian.audit.plugin.upgrade.UpgradeTaskCollector;
import com.atlassian.audit.plugin.upgrade.task.UpgradeTask1MigrateLegacyEvents;
import com.atlassian.audit.plugin.upgrade.task.UpgradeTask2MigrateLegacyRetentionConfig;
import com.atlassian.audit.spi.migration.LegacyAuditEntityMigrator;
import com.atlassian.audit.spi.migration.LegacyRetentionConfigProvider;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import static com.atlassian.plugins.osgi.javaconfig.ExportOptions.as;
import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.exportOsgiService;
import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.importOsgiService;

@Configuration
public class AuditUpgradeConfiguration {
    @Bean
    public LegacyAuditEntityMigrator legacyAuditEntityMigrator() {
        return importOsgiService(LegacyAuditEntityMigrator.class);
    }

    @Bean
    public UpgradeTask1MigrateLegacyEvents migrateLegacyEventsUpgradeTask(LegacyAuditEntityMigrator legacyAuditEntityMigrator,
                                                                          DatabaseAuditConsumer databaseAuditConsumer) {
        return new UpgradeTask1MigrateLegacyEvents(legacyAuditEntityMigrator, databaseAuditConsumer);
    }

    @Bean
    public LegacyRetentionConfigProvider productRetentionConfigProvider() {
        return importOsgiService(LegacyRetentionConfigProvider.class);
    }

    @Bean
    public UpgradeTask2MigrateLegacyRetentionConfig upgradeTask2MigrateRetentionConfig(@PermissionsNotEnforced AuditRetentionConfigService auditRetentionConfigService,
                                                                                       LegacyRetentionConfigProvider configProvider) {
        return new UpgradeTask2MigrateLegacyRetentionConfig(auditRetentionConfigService, configProvider);
    }

    /*
     * Begin exporting of SAL upgrade tasks for products other than Jira.
     * Upgrade tasks for Jira are wired separately in upgradeTaskCollector below
     */
    @SuppressWarnings("rawtypes")
    @Bean
    @Conditional(NonJira.class)
    public FactoryBean<ServiceRegistration> publishMigrateLegacyEventsUpgradeTask(UpgradeTask1MigrateLegacyEvents migrateLegacyEventsUpgradeTask) {
        return exportOsgiService(migrateLegacyEventsUpgradeTask, as(PluginUpgradeTask.class));
    }

    @SuppressWarnings("rawtypes")
    @Bean
    @Conditional(NonJira.class)
    public FactoryBean<ServiceRegistration> publishMigrateRetentionConfigUpgradeTask(UpgradeTask2MigrateLegacyRetentionConfig upgradeTask2MigrateLegacyRetentionConfig) {
        return exportOsgiService(upgradeTask2MigrateLegacyRetentionConfig, as(PluginUpgradeTask.class));
    }

    /*
     * End exporting of SAL upgrade tasks for products other than Jira.
     */

    /*
     * atlassian-upgrade-task-framework (AUTF) upgrade task factory for Jira.
     * ZDU in Jira requires plugins to use AUTF which is not available in other products atm (Jan 2020)
     */
    @Bean
    @Conditional(JiraOnly.class)
    public UpgradeTaskCollector upgradeTaskCollector(UpgradeTask1MigrateLegacyEvents upgradeTask1MigrateLegacyEvents,
                                                     UpgradeTask2MigrateLegacyRetentionConfig upgradeTask2MigrateLegacyRetentionConfig) {
        return new UpgradeTaskCollector(
                ImmutableList.of(upgradeTask1MigrateLegacyEvents, upgradeTask2MigrateLegacyRetentionConfig));
    }
}
