package com.atlassian.audit.permission;

import com.atlassian.audit.plugin.configuration.PropertiesProvider;
import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.sal.api.user.UserManager;

import javax.annotation.Nonnull;

/**
 * This checker allows to define a System Property which will restrict all audit log operations for sys admin only.
 */
public class SysPropBasedPermissionChecker implements PermissionChecker {
    /**
     * @deprecated
     * Bitbucket throws java.lang.IllegalArgumentException: Property name "audit.log.view.sysadmin.only" does not start
     * with "plugin." when using this property in the bitbucket.properties file
     */
    @Deprecated
    private static final String LEGACY_SYS_ADMIN_ONLY_SYS_PROP_KEY = "audit.log.view.sysadmin.only";
    private static final String SYS_ADMIN_ONLY_SYS_PROP_KEY = "plugin.audit.log.view.sysadmin.only";

    private final UserManager userManager;

    private final ResourceContextPermissionChecker resourcePermissionChecker;

    private final PropertiesProvider propertiesProvider;

    public SysPropBasedPermissionChecker(@Nonnull UserManager userManager,
                                         @Nonnull ResourceContextPermissionChecker resourcePermissionChecker,
                                         PropertiesProvider propertiesProvider) {
        this.userManager = userManager;
        this.resourcePermissionChecker = resourcePermissionChecker;
        this.propertiesProvider = propertiesProvider;
    }

    @Override
    public boolean hasUnrestrictedAuditViewPermission() {
        return isSysAdmin() || (allowAdminToSeeLogs() && isAdmin());
    }

    @Override
    public boolean hasResourceAuditViewPermission(@Nonnull String resourceType, @Nonnull String resourceId) {
        return resourcePermissionChecker.hasResourceAuditViewPermission(resourceType, resourceId) ||
                hasUnrestrictedAuditViewPermission();
    }

    @Override
    public boolean hasCoverageConfigViewPermission() {
        return isSysAdmin() || (allowAdminToSeeLogs() && isAdmin());
    }

    @Override
    public boolean hasCoverageConfigUpdatePermission() {
        return isSysAdmin();
    }

    @Override
    public boolean hasRetentionConfigViewPermission() {
        return isSysAdmin() || (allowAdminToSeeLogs() && isAdmin());
    }

    @Override
    public boolean hasRetentionConfigUpdatePermission() {
        return isSysAdmin();
    }

    private boolean isAdmin() {
        return userManager.isAdmin(userManager.getRemoteUserKey());
    }

    private boolean isSysAdmin() {
        return userManager.isSystemAdmin(userManager.getRemoteUserKey());
    }

    private boolean allowAdminToSeeLogs() {
        return !(propertiesProvider.getBoolean(SYS_ADMIN_ONLY_SYS_PROP_KEY) ||
                Boolean.getBoolean(LEGACY_SYS_ADMIN_ONLY_SYS_PROP_KEY));
    }
}
