package com.atlassian.audit.lookup.rest;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.rest.model.AuditResourceLookupJson;
import com.atlassian.audit.rest.model.RestPage;
import com.atlassian.audit.rest.model.RestPageCursor;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import javax.annotation.Nonnull;
import javax.ws.rs.core.UriInfo;
import java.util.List;
import java.util.function.Function;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditResourceResponseJson extends RestPage<AuditResourceLookupJson, String> {

    public AuditResourceResponseJson(Page<AuditResource, String> page,
                                     Function<AuditResource, AuditResourceLookupJson> restTransform, String baseUrl, UriInfo uriInfo) {
        super(page, restTransform, baseUrl, uriInfo);
    }

    @Nonnull
    @JsonProperty("resources")
    public List<AuditResourceLookupJson> getEntities() {
        return super.getValues();
    }

    @Nonnull
    @Override
    protected RestPageCursor serializeCursor(@Nonnull String cursor) {
        return () -> cursor;
    }
}
