package com.atlassian.audit.frontend.data;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditingOnboardingDisplayInfoData {

    @JsonIgnore
    private final boolean dcOnly;

    @JsonProperty("title")
    private final String title;

    @JsonProperty("description")
    private final String description;

    @JsonProperty("image")
    private final String image;

    @JsonProperty("articleLink")
    private final String articleLink;

    @JsonProperty("buttonLabels")
    private final ButtonLabels buttonLabels;

    public AuditingOnboardingDisplayInfoData(final boolean dcOnly, final String title, final String description,
                                             final String image, final String articleLink,
                                             final String confirmButtonLabel, final String learnMoreButtonLabel
    ) {
        this.dcOnly = dcOnly;
        this.title = title;
        this.description = description;
        this.image = image;
        this.articleLink = articleLink;
        this.buttonLabels = new ButtonLabels(learnMoreButtonLabel, confirmButtonLabel);
    }

    public boolean isDcOnly() {
        return dcOnly;
    }

    public class ButtonLabels {

        @JsonProperty("learnMore")
        private String learnMore;

        @JsonProperty("confirm")
        private String confirm;

        public ButtonLabels(String learnMore, String confirm) {
            this.learnMore = learnMore;
            this.confirm = confirm;
        }
    }
}