package com.atlassian.audit.frontend.data;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditPermissionData {

    /**
     * A flag indicates if view configuration is allowed
     */
    @JsonProperty("allowViewConfiguration")
    private boolean allowViewConfiguration;

    /**
     * A flag indicates if update configuration is allowed
     */
    @JsonProperty("allowUpdateConfiguration")
    private boolean allowUpdateConfiguration;

    public AuditPermissionData allowUpdateConfiguration(boolean allowUpdateConfiguration) {
        this.allowUpdateConfiguration = allowUpdateConfiguration;
        return this;
    }

    public AuditPermissionData allowViewConfiguration(boolean allowViewConfiguration) {
        this.allowViewConfiguration = allowViewConfiguration;
        return this;
    }
}