package com.atlassian.audit.frontend.data;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditEventsViewData {

    private String pageTitle;

    private boolean selectiveExportEnabled = false;

    private String serverTimeZone;

    private String userTimeZone;

    private String userLocale;

    private boolean dcFilter;
    
    private long totalCountInDatabase;

    private List<AffectedObjectsFilter> affectedObjectsFilters = new ArrayList<>();

    private List<String> globalAffectedObjectsFilters = new ArrayList<>();

    private Map<String, List<String>> delegatedViewsAffectedObjectFilters = new HashMap<>();

    private List<String> categoryFilterValues = new ArrayList<>();
    private List<String> actionFilterValues = new ArrayList<>();

    public AuditEventsViewData withSelectiveExportEnabled(boolean selectiveExportEnabled) {
        this.selectiveExportEnabled = selectiveExportEnabled;
        return this;
    }

    public AuditEventsViewData withPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return this;
    }

    public AuditEventsViewData withUserTimeZone(String userTimeZone) {
        this.userTimeZone = userTimeZone;
        return this;
    }

    public AuditEventsViewData withServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
        return this;
    }

    public AuditEventsViewData withUserLocale(String userLocale) {
        this.userLocale = userLocale;
        return this;
    }

    public AuditEventsViewData withDcFilter(boolean dcFilter) {
        this.dcFilter = dcFilter;
        return this;
    }

    public AuditEventsViewData affectedObjectsFilters(Collection<AffectedObjectsFilter> affectedObjectsFilter) {
        this.affectedObjectsFilters.addAll(affectedObjectsFilter);
        return this;
    }

    public AuditEventsViewData globalAffectedObjectsFilters(Collection<String> globalAffectedObjectsFilters) {
        this.globalAffectedObjectsFilters.addAll(globalAffectedObjectsFilters);
        return this;
    }

    public AuditEventsViewData delegatedAffectedObjectsFilters(Map<String, List<String>> delegatedViewsAffectedObjectFilters) {
        this.delegatedViewsAffectedObjectFilters.putAll(delegatedViewsAffectedObjectFilters);
        return this;
    }

    public AuditEventsViewData categoryFilter(@Nonnull List<String> categories) {
        this.categoryFilterValues.addAll(categories);
        return this;
    }

    public AuditEventsViewData categoryFilter(@Nonnull String... categories) {
        this.categoryFilterValues.addAll(Arrays.asList(categories));
        return this;
    }

    public AuditEventsViewData actionFilter(@Nonnull List<String> actions) {
        this.actionFilterValues.addAll(actions);
        return this;
    }

    public AuditEventsViewData actionFilter(@Nonnull String... actions) {
        this.actionFilterValues.addAll(Arrays.asList(actions));
        return this;
    }

    public AuditEventsViewData count(long count) {
        this.totalCountInDatabase = count;
        return this;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public boolean isSelectiveExportEnabled() {
        return selectiveExportEnabled;
    }

    public String getUserTimeZone() {
        return userTimeZone;
    }

    public String getServerTimeZone() {
        return serverTimeZone;
    }

    public String getUserLocale() {
        return userLocale;
    }

    public boolean isDcFilter() {
        return dcFilter;
    }

    public List<AffectedObjectsFilter> getAffectedObjectsFilters() {
        return affectedObjectsFilters;
    }

    public List<String> getGlobalAffectedObjectsFilters() {
        return globalAffectedObjectsFilters;
    }

    public Map<String, List<String>> getDelegatedViewsAffectedObjectFilters() {
        return delegatedViewsAffectedObjectFilters;
    }

    public List<String> getCategoryFilterValues() {
        return categoryFilterValues;
    }

    public List<String> getActionFilterValues() {
        return actionFilterValues;
    }

    public long getTotalCountInDatabase() {
        return totalCountInDatabase;
    }

    @Override
    public String toString() {
        return "AuditGlobalViewData{" +
                "pageTitle='" + pageTitle + '\'' +
                ", selectiveExportEnabled=" + selectiveExportEnabled +
                ", serverTimeZone='" + serverTimeZone + '\'' +
                ", userTimeZone='" + userTimeZone + '\'' +
                ", userLocale='" + userLocale + '\'' +
                ", dcFilter=" + dcFilter +
                ", affectedObjectsFilters=" + affectedObjectsFilters +
                ", globalAffectedObjectsFilters=" + globalAffectedObjectsFilters +
                ", delegatedViewsAffectedObjectFilters=" + delegatedViewsAffectedObjectFilters +
                ", categoryFilterValues=" + categoryFilterValues +
                ", actionFilterValues=" + actionFilterValues +
                ", totalCountInDatabase=" + totalCountInDatabase +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditEventsViewData)) {
            return false;
        }
        AuditEventsViewData that = (AuditEventsViewData) o;
        return selectiveExportEnabled == that.selectiveExportEnabled &&
                dcFilter == that.dcFilter &&
                Objects.equals(pageTitle, that.pageTitle) &&
                Objects.equals(serverTimeZone, that.serverTimeZone) &&
                Objects.equals(userTimeZone, that.userTimeZone) &&
                Objects.equals(userLocale, that.userLocale) &&
                Objects.equals(affectedObjectsFilters, that.affectedObjectsFilters) &&
                Objects.equals(globalAffectedObjectsFilters, that.globalAffectedObjectsFilters) &&
                Objects.equals(delegatedViewsAffectedObjectFilters, that.delegatedViewsAffectedObjectFilters) &&
                Objects.equals(categoryFilterValues, that.categoryFilterValues) &&
                Objects.equals(actionFilterValues, that.actionFilterValues) &&
                Objects.equals(totalCountInDatabase, that.totalCountInDatabase);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageTitle, selectiveExportEnabled, serverTimeZone, userTimeZone, userLocale, dcFilter, affectedObjectsFilters, globalAffectedObjectsFilters, delegatedViewsAffectedObjectFilters, categoryFilterValues, actionFilterValues, totalCountInDatabase);
    }

    /**
     * What's needed for a frontend affected object type filter
     * <p>
     * TODO: [QUICK-1878] Move this out to be exposed when we get products to provide this information for us
     */
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AffectedObjectsFilter {
        private String resourceType;
        private String placeholderText;

        public AffectedObjectsFilter(String resourceType, String placeholderText) {
            this.resourceType = resourceType;
            this.placeholderText = placeholderText;
        }

        public String getResourceType() {
            return resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getPlaceholderText() {
            return placeholderText;
        }

        public void setPlaceholderText(String placeholderText) {
            this.placeholderText = placeholderText;
        }

        @Override
        public String toString() {
            return "{" +
                    "resourceType='" + resourceType + '\'' +
                    ", placeholderText='" + placeholderText + '\'' +
                    '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            AffectedObjectsFilter that = (AffectedObjectsFilter) o;
            return Objects.equals(resourceType, that.resourceType) &&
                    Objects.equals(placeholderText, that.placeholderText);

        }

        @Override
        public int hashCode() {
            return Objects.hash(resourceType, placeholderText);
        }
    }

}
