package com.atlassian.audit.frontend.conditions;

import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.audit.spi.feature.DelegatedViewFeature;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;

/**
 * A condition which checks if the user can view delegated auditing UI.
 */
public class JiraCanViewDelegatedUICondition implements Condition {
    public static final String RESOURCE_TYPE = "PROJECT";

    private final PermissionChecker permissionChecker;
    private final DelegatedViewFeature delegatedViewFeature;

    public JiraCanViewDelegatedUICondition(PermissionChecker permissionChecker, DelegatedViewFeature delegatedViewFeature) {
        this.permissionChecker = permissionChecker;
        this.delegatedViewFeature = delegatedViewFeature;
    }

    @Override
    public final void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> stringObjectMap) {
        final String resourceId = (String) stringObjectMap.get("projectKeyEncoded");
        if (resourceId == null) {
            return false;
        }
        return delegatedViewFeature.isEnabled() && permissionChecker.hasResourceAuditViewPermission(RESOURCE_TYPE, resourceId);
    }
}
