package com.atlassian.audit.frontend.conditions;

import com.atlassian.audit.spi.feature.DelegatedViewFeature;
import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Map;

import static java.util.Objects.requireNonNull;

public class ConfluenceCanViewDelegatedUICondition implements Condition {
    private static final String SPACE_ID_KEY = "spaceid";
    private static final String SPACE_RESOURCE_TYPE = "Space";
    private final ResourceContextPermissionChecker permissionChecker;
    private final DelegatedViewFeature delegatedViewFeature;

    public ConfluenceCanViewDelegatedUICondition(@Qualifier("resourceContextPermissionChecker") ResourceContextPermissionChecker permissionChecker, DelegatedViewFeature delegatedViewFeature) {
        this.permissionChecker = requireNonNull(permissionChecker);
        this.delegatedViewFeature = requireNonNull(delegatedViewFeature);
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> context) {
        // Retrieve current space's Id from webInterfaceContext, if any
        Object spaceId = context.get(SPACE_ID_KEY);
        return (spaceId instanceof Long)
                && delegatedViewFeature.isEnabled()
                && permissionChecker.hasResourceAuditViewPermission(SPACE_RESOURCE_TYPE, String.valueOf(spaceId));
    }
}
